<?php

namespace UtillzCore\Inc\Src\Form\Modules\Taxonomy;

use \UtillzCore\Inc\Src\Form\Modules\Module;

class Taxonomy extends Module {

    public $parent = '';
    public $allowed_formats;

    public function before_construct() {

        $this->allowed_formats = [
            'term_id',
            'name',
            'slug',
        ];

        $this->defaults += [
            'options' => [],
            'display' => 'select',
            'format' => 'term_id>>>name',
            'allow_empty' => true,
        ];

    }

    public function after_build() {

        if( empty( $this->props->id ) ) {
            $this->props->id = $this->props->taxonomy;
        }elseif( empty( $this->props->taxonomy ) ) {
            $this->props->taxonomy = $this->props->id;
        }

    }

    public function finish() {

        // listing type
        if( $this->props->taxonomy == 'ulz_listing_type' ) {
            $tax_query = [];
            $listing_types = get_posts([
                'post_type' => 'ulz_listing_type',
                'post_status' => 'publish',
            ]);
            foreach( $listing_types as $listing_type ) {
                $tax_query[] = (object) [
                    'term_id' => $listing_type->ID,
                    'name' => $listing_type->post_title,
                    'slug' => get_post_meta( $listing_type->ID, 'ulz_slug', true ),
                ];
            }
        }
        // taxonomy
        else{

            // exclude terms by getting their listing types
            // you can specify if terms are visible for any listing types
            // if their listing type is empty, the term will be visible for all listing types
            global $ulz_filter;

            $tax_meta_query = [
                'relation' => 'OR'
            ];

            if( isset( $ulz_filter->type ) && ! empty( $ulz_filter->type ) ) {
                $tax_meta_query[] = [
                    'key' => 'ulz_term_listing_types',
                    'value' => $ulz_filter->type,
                    'compare' => '=',
                ];
                $tax_meta_query[] = [
                    'key' => 'ulz_term_listing_types',
                    'compare' => 'NOT EXISTS'
                ];
            }

            $tax_query = get_terms( $this->props->taxonomy, [
                'hide_empty' => false,
                'meta_query' => $tax_meta_query,
                'parent' => $this->parent
            ]);

        }

        if( ! is_wp_error( $tax_query ) ) {

            $options = [];

            $format = explode( '>>>', $this->props->format );

            foreach( $tax_query as $tq ) {
                if( in_array( $format[0], $this->allowed_formats ) && in_array( $format[1], $this->allowed_formats ) ) {
                    $options[ $tq->{$format[0]} ] = $tq->{$format[1]};
                }
            }

            $this->props->options = $options;

        }

    }

    public function after_save( $post_id, $value ) {

        $term_ids = [];
        if( is_array( $value ) ) {
            foreach( $value as $val ) {
                if( term_exists( (int) $val, $this->props->id ) ) {
                    $term_ids[] = (int) $val;
                }
            }
        }else{
            if( term_exists( (int) $value, $this->props->id ) ) {
                $term_ids[] = (int) $value;
            }
        }

        wp_set_object_terms( $post_id, $term_ids, $this->props->id );

        return $value;

    }

    public function get() {
        if( empty( $this->props->options ) ) {
            return parent::get();
        }else{
            return $this->template();
        }
    }

    public function module_get() {
        return parent::get();
    }

    public function controller() {

        return array_merge( (array) $this->props, [
            'props' => (array) $this->props,
            'component' => $this->component,
            'strings' => (object) [
                'not_found' => esc_html__('There are no terms to display', 'utillz-core')
            ],
        ]);

    }

}
